/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.udp.wifi;

import com.gprinter.udp.CommandUDP;
import com.gprinter.udp.Response;
import com.gprinter.udp.wifi.SearchWifiDeviceResp;
import com.gprinter.utils.LogUtils;
import java.util.regex.Pattern;

public class SearchWifiDeviceCommand
extends CommandUDP {
    String command = "HF-A11ASSISTHREAD";

    @Override
    public byte[] getCommand() {
        String str = "HF-A11ASSISTHREAD";
        return str.getBytes();
    }

    @Override
    public Response resolveResponseData(long uuid, byte[] bytes) {
        try {
            String str = new String(bytes);
            if (str.startsWith(this.command)) {
                str = str.replace(this.command, "");
            }
            LogUtils.e("\u89e3\u6790\u6570\u636e" + str);
            return SearchWifiDeviceCommand.decodeBroadcast2Module(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized SearchWifiDeviceResp decodeBroadcast2Module(String response) {
        if (response == null) {
            return null;
        }
        String[] array = response.split(",");
        if (array == null || array.length < 2 && array.length > 3 || !SearchWifiDeviceCommand.isIP(array[0]) || !SearchWifiDeviceCommand.isMAC(array[1])) {
            LogUtils.e("\u53c2\u6570\u4e0d\u6b63\u786e");
            return null;
        }
        SearchWifiDeviceResp wiFiDeviceResp = new SearchWifiDeviceResp();
        wiFiDeviceResp.setIp(array[0]);
        wiFiDeviceResp.setMac(array[1]);
        if (array.length == 3) {
            wiFiDeviceResp.setModuleID(array[2]);
        }
        return wiFiDeviceResp;
    }

    public static boolean isIP(String str) {
        Pattern pattern = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
        return pattern.matcher(str).matches();
    }

    public static boolean isMAC(String str) {
        if ((str = str.trim()).length() != 12) {
            return false;
        }
        char[] chars = new char[12];
        str.getChars(0, 12, chars, 0);
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9' || chars[i] >= 'A' && chars[i] <= 'F' || chars[i] >= 'a' && chars[i] <= 'f') continue;
            return false;
        }
        return true;
    }
}

